// Internal domain specific constants used throughout the
// application.  Constants do not change throughout the lifecycle
// of development.  Centralizes all global values used for
// during configuration, runtime checks, etc.

import { AppUserGroup } from "@/zod/amplify.schema";

export const CURRENT_SESSION_COOKIE_KEY = 'session';

export const userGroupDescriptions = [
  {
    display: "Administrator",
    description: "Administrators can do everything, including managing users, uploading feed content, adding statewide services, and more.",
    value: 'ADMIN' satisfies AppUserGroup,
  }, {
    display: "Agency Viewer",
    description: "Viewers cannot manage other users information, upload files, but they have access to the preview version of the Trip planner.",
    value: 'VIEWER' satisfies AppUserGroup,
  }
] as const


export const INTERNAL__BASE_FADE_IN_DELAY = 0.25
export const INTERNAL__BASE_FADE_IN_DELAY_2 = 0.5
